#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from OSEHRAHelper import PROMPT

def AddOneClinic(VistA,clinicname,abbreviation,phonenumber,provider,stopcode,creditstopcode,servicetype,noncount,parentdiv,parentinst,appointmentlength):
  is_visn0 = "ALABAMA" == "CALIFORNIA" # assume CALIFONIA is using VISN0's data
  VistA.write('S DUZ=1 D ^XUP')
  VistA.wait('Select OPTION NAME')
  VistA.write('SDMGR')
  VistA.wait('Select Scheduling Manager\'s Menu Option:')
  VistA.write('Supervisor Menu')
  VistA.wait('Select Supervisor Menu Option:')
  VistA.write('Set up a Clinic')
  VistA.wait('CLINIC NAME')
  VistA.write(clinicname + '\rY')
  VistA.wait('NAME')
  VistA.write('')
  VistA.wait('ABBREVIATION')
  VistA.write(abbreviation)
  VistA.wait('CLINIC MEETS')
  VistA.write('Y')
  VistA.wait('SERVICE')
  VistA.write(servicetype)
  VistA.wait('NON-COUNT CLINIC')
  VistA.write(noncount)
  VistA.wait('DIVISION')
  VistA.write(parentdiv)
  VistA.wait('STOP CODE NUMBER')
  VistA.write(stopcode)
  VistA.wait('DEFAULT APPOINTMENT TYPE')
  VistA.write('')
  VistA.wait('ADMINISTER INPATIENT MEDS')
  VistA.write('')  
  VistA.wait('TELEPHONE')
  VistA.write(phonenumber)
  VistA.wait('REQUIRE X-RAY FILMS')
  VistA.write('')
  VistA.wait('REQUIRE ACTION PROFILES')
  VistA.write('Y')
  VistA.wait('NO SHOW LETTER')
  VistA.write('')
  VistA.wait('PRE-APPOINTMENT LETTER')
  VistA.write('')
  VistA.wait('CLINIC CANCELLATION LETTER')
  VistA.write('')
  VistA.wait('APPT. CANCELLATION LETTER')
  VistA.write('')
  VistA.wait('ASK FOR CHECK IN/OUT TIME')
  VistA.write('')
  VistA.wait('Select PROVIDER')
  VistA.write(provider + '\rY')
  VistA.wait('PROVIDER')
  VistA.write('')
  VistA.wait('DEFAULT PROVIDER')
  VistA.write('')
  VistA.wait('Select PROVIDER')
  VistA.write('')
  VistA.wait('DEFAULT TO PC PRACTITIONER')
  VistA.write('')
  VistA.wait('Select DIAGNOSIS')
  VistA.write('')
  VistA.wait('WORKLOAD VALIDATION AT CHK OUT')
  VistA.write('Y')
  VistA.wait('ALLOWABLE CONSECUTIVE NO-SHOWS')
  VistA.write('1')
  VistA.wait('FUTURE BOOKING')
  VistA.write('365')
  OptionalList = ['HOUR CLINIC DISPLAY BEGINS',
                  'START TIME FOR AUTO REBOOK']
  while True:
    index = VistA.multiwait(OptionalList)
    VistA.write('8')
    if index == len(OptionalList) -1 :
      break
  VistA.wait('DAYS FOR AUTO-REBOOK')
  VistA.write('1')
  VistA.wait('SCHEDULE ON HOLIDAYS')
  VistA.write('')
  VistA.wait('CREDIT STOP CODE')
  VistA.write(creditstopcode)
  VistA.wait('PROHIBIT ACCESS TO CLINIC')
  VistA.write('')
  VistA.wait('PHYSICAL LOCATION')
  VistA.write('')
  VistA.wait('PRINCIPAL CLINIC')
  VistA.write('')
  VistA.wait('OVERBOOKS/DAY MAXIMUM')
  VistA.write('1')
  VistA.wait('Select SPECIAL INSTRUCTIONS')
  VistA.write('')
  VistA.wait('LENGTH OF APP\'T')
  VistA.write(appointmentlength)
  VistA.wait('VARIABLE')
  VistA.write('Yes')
  OptionalList = ['DISPLAY INCREMENTS PER HOUR',
                  'AVAILABILITY DATE:']
  while True:
    index = VistA.multiwait(OptionalList)
    if index == 0:
      slots = 60/int(appointmentlength)
      VistA.write(str(slots))
      continue
    else:
      break
  dates = ['JUL 2,2012','JUL 3,2012','JUL 4,2012','JUL 5,2012','JUL 6,2012']
  for date in dates:
    VistA.write(date)
    VistA.wait('TIME')
    VistA.write('0800-1200\r2')
    VistA.wait('TIME')
    VistA.write('1230-1500\r2')
    VistA.wait('TIME')
    VistA.write('')
    VistA.wait('PATTERN OK')
    VistA.write('Yes')
    VistA.wait('AVAILABILITY DATE')
  VistA.write('')
  VistA.wait('Select CLINIC NAME')
  VistA.write('')
  VistA.wait('Supervisor Menu Option')
  VistA.write('')
  VistA.wait('Select Scheduling Manager\'s Menu Option:')
  VistA.write('')
  VistA.wait('Do you really want to halt')
  VistA.write('')
  VistA.wait(PROMPT)
  VistA.write('D Q^DI')
  VistA.wait('Select OPTION')
  VistA.write('1')
  VistA.wait('INPUT TO WHAT FILE')
  VistA.write('HOSPITAL LOCATION')
  VistA.wait('EDIT WHICH FIELD')
  VistA.write('INSTITUTION')
  VistA.wait('THEN EDIT FIELD')
  VistA.write('')
  VistA.wait('Select HOSPITAL LOCATION NAME')
  VistA.write(clinicname)
  VistA.wait('INSTITUTION')
  VistA.write(parentinst)
  VistA.wait('Select HOSPITAL LOCATION NAME')
  VistA.write('')
  VistA.wait('Select OPTION')
  VistA.write('')
